<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

class Qoxag_Post_Category extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'post-category';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Category Widget', 'qoxag');
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Category settings', 'qoxag'),
            ]
        );

        if (class_exists('ElementsKit_Lite')) {

            $this->add_control(
                'category_style',
                [
                    'label' => esc_html__('Category style', 'qoxag'),
                    'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
                    'default' => 'style1',
                    'options' => [
                        'style1'  => [
                            'title' => esc_html__('Style 1', 'qoxag'),
                            'imagelarge' => QOXAG_IMG . '/style/title/style1.png',
                            'imagesmall' => QOXAG_IMG . '/style/title/style1.png',
                            'width' => '30%',
                        ],
                    ],
                ]
            );
        } else {
            $this->add_control(
                'category_style',
                [
                    'label' => esc_html__('Category Style', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'style1',
                    'options' => [
                        'style1'  => esc_html__('Style 1', 'qoxag'),
                    ],
                ]
            );
        }

        $this->add_control(
            'categories_id',
            [
                'label' => esc_html__('Select Categories', 'qoxag'),
                'type'      => \Elementor\Controls_Manager::SELECT2,
                'options'   => $this->post_category(),
                'label_block' => true,
                'multiple'  => true,
            ]
        );

        $this->add_control(
            'category_limit',
            [
                'label'   => esc_html__('Limit categories', 'qoxag'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'step'    => 1,
            ]
        );

        $this->add_control(
            'post_sort_by',
            [
                'label' => esc_html__('Sort By', 'qoxag'),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC'  => esc_html__('ASC', 'qoxag'),
                    'DESC'  => esc_html__('DESC', 'qoxag'),
                ],
            ]
        );

        $this->add_control(
            'hide_empty',
            [
                'label'     => esc_html__('hide Empty?', 'qoxag'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => '',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_category_style',
            [
                'label'     => esc_html__('Category Title', 'qoxag'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'category_color',
            [
                'label'         => esc_html__('Category color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'default'    => '#202020',
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .ts-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_hover_color',
            [
                'label'         => esc_html__('Category Hover color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'default'    => '#202020',
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item:hover .cat-content .ts-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_title_typography',
                'label' => esc_html__('Catgory Title Typography', 'qoxag'),
                'selector' => '
                    {{WRAPPER}} .ts-event-category .cat-item .cat-content .ts-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '23',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '30',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => ['0'],
                'selectors' => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .ts-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_category_desc_style',
            [
                'label'     => esc_html__('Category Desceiption', 'qoxag'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'category_desc_color',
            [
                'label'         => esc_html__('Category Desc color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'default'    => '#202020',
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_desc_typography',
                'label' => esc_html__('Catgory Desc Typography', 'qoxag'),
                'selector' => '
                    {{WRAPPER}} .ts-event-category .cat-item .cat-content .description p',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '23',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '30',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'category_description_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_category_button_style',
            [
                'label'     => esc_html__('Category Button', 'qoxag'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'category_button_color',
            [
                'label'         => esc_html__('Category Button Color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_button_hover_color',
            [
                'label'         => esc_html__('Category Button Hover Color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item:hover .cat-content .description a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_button_typography',
                'label' => esc_html__('Catgory Button Typography', 'qoxag'),
                'selector' => '
                    {{WRAPPER}} .ts-event-category .cat-item .cat-content .description a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '23',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '30',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );
        $this->add_control(
            'button_background_color',
            [
                'label'         => esc_html__('Button Background Color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description a' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover_color',
            [
                'label'         => esc_html__('Button Background Hover Color', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item:hover .cat-content .description a' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => ['0'],
                'selectors' => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'Border',
                'label' => esc_html__('Border', 'qoxag'),
                'selector' => '{{WRAPPER}} .ts-event-category .cat-item .cat-content .description a',
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'content_wrapper',
            [
                'label'     => esc_html__('Content Wrapper', 'qoxag'),
                'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_wrapper_bg',
            [
                'label'         => esc_html__('Content Background', 'qoxag'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_wrapper_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .ts-event-category .cat-item .cat-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $settings           = $this->get_settings();
        $category_style     = $settings['category_style'];
        $categories_id      = $settings['categories_id'];

        $qoxag_category_settings = array(
            'category_style'    =>  $settings['category_style'],
            'hide_empty'    => $settings['hide_empty'],
            'category-options'   => array(
                'category_limit'  => $settings['category_limit'],
                'categories_id'  => $settings['categories_id'],
                'post_sort_by'  => $settings['post_sort_by']
            )
        );

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template() {}

    public function post_category()
    {

        $terms = get_terms(array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1,
        ));

        $cat_list = [];
        if (!empty($terms)) {
            foreach ($terms as $post) {
                $cat_list[$post->term_id]  = [$post->name];
            }
        }
        return $cat_list;
    }
}
